/**
* Script: repairstate.js
* Written by: Radnen
* Updated: 2/23/2011
**/

function RepairState(name) {
	if (!name) name = "RepairState";
	this.inherit = State;
	this.inherit(name);
	
	this.ship = Genesis.player.ship;
	this.x = SW/2-200;
	this.y = SH/2-140;
	this.rep_cost = (this.ship.hp.max-this.ship.hp.value)*20;
	this.ref_cost = (this.ship.jumps.max-this.ship.jumps.value)*100;
	this.rec_cost = (this.ship.shields.max-this.ship.shields.value)*10;
	
	this.credits = new TimedValue(Genesis.player.credits, 500);
	
	this.backbutton = new EasyButton("Back", this.x+180, this.y+240);
	this.backbutton.onClick.add(function(sender) {
		Audio.playSound(System.clickSnd);
		sender.hide();
	}, this);
	
	this.repbutton = new EasyButton("Repair", this.x+250, this.y+54);
	this.repbutton.onClick.add(function(sender) {
		if (sender.rep_cost == 0) return;
		while(sender.rep_cost > Genesis.player.credits) {
			sender.rep_cost -= 20;
		}
		var val_before = this.ship.hp.value;
		this.ship.hp.value += sender.rep_cost/20;
		Genesis.player.credits -= sender.rep_cost;
		sender.credits.scale(Genesis.player.credits);
		sender.rep_cost = (this.ship.hp.max-this.ship.hp.value)*20;
		if (val_before != this.ship.hp.value) Audio.playSound(Resources.sounds.money);
	}, this);

	this.refbutton = new EasyButton("Refuel", this.x+250, this.y+84);
	this.refbutton.onClick.add(function(sender) {
		if (sender.ref_cost == 0) return;
		while(sender.ref_cost > Genesis.player.credits) {
			sender.ref_cost -= 100;
		}
		var val_before = Genesis.player.jumps.value;
		this.ship.jumps.value += sender.ref_cost/100;
		Genesis.player.credits -= sender.ref_cost;
		sender.credits.scale(Genesis.player.credits);
		sender.ref_cost = (this.ship.jumps.max-this.ship.jumps.value)*100;
		if (val_before != this.ship.jumps.value) Audio.playSound(Resources.sounds.money);
	}, this);
	
	this.recbutton = new EasyButton("Recharge", this.x+250, this.y+114);
	this.recbutton.onClick.add(function(sender) {
		if (sender.rec_cost == 0) return;
		while(sender.rec_cost > Genesis.player.credits) {
			sender.rec_cost -= 10;
		}
		var val_before = this.ship.shields.value;
		this.ship.shields.value += sender.rec_cost/10;
		Genesis.player.credits -= sender.rec_cost;
		sender.credits.scale(Genesis.player.credits);
		sender.rec_cost = (this.ship.shields.max-this.ship.shields.value)*10;
		if (val_before != this.ship.shields.value) Audio.playSound(Resources.sounds.money);
	}, this);	
	
	this.render.add(function() {
		Rectangle(this.x, this.y, 400, 280, Colors.black);
		OutlinedRectangle(this.x, this.y, 400, 280, Colors.gray);
		DrawCenteredText(this.x, this.y, 400, "- Garage -");
		System.textFont.drawText(this.x+4, this.y+24, "Player's Credits: " + Math.floor(this.credits.value));
		System.textFont.drawText(this.x+4, this.y+54, "Repair Cost: " + this.rep_cost);
		System.textFont.drawText(this.x+4, this.y+84, "Refuel Cost: " + this.ref_cost);
		System.textFont.drawText(this.x+4, this.y+114, "Recharge Cost: " + this.rec_cost);
		GameHud.drawStatusBar("Armor", SW/2, SH/2+16, this.ship.hp, Colors.green, Colors.darkGreen);
		GameHud.drawStatusBar("Fuel", SW/2, SH/2+40, this.ship.jumps, Colors.purple, Colors.darkPurple);
		GameHud.drawStatusBar("Battery", SW/2, SH/2+64, this.ship.shields, Colors.blue, Colors.darkBlue);
		this.backbutton.draw();
		this.repbutton.draw();
		this.refbutton.draw();
		this.recbutton.draw();
	});
	
	this.update.add(function() {
		if (!this.credits.update()) this.backbutton.update();
		this.repbutton.update();
		this.refbutton.update();
		this.recbutton.update();
	});
}

function DrawBorderedText(x, y, text)
{
	var h = System.textFont.getHeight();
	var sw = System.textFont.getStringWidth(text);
	Rectangle(x-4, y-4, sw+8, h+8, GameHud.hudColor);
	OutlinedRectangle(x-4, y-4, sw+8, h+8, Colors.gray);
	System.textFont.drawText(x, y, text);
}

function DrawCenteredText(x, y, w, text)
{
	var h = System.textFont.getHeight();
	var sw = System.textFont.getStringWidth(text);
	Rectangle(x+w/2-sw/2-4, y-h/2-4, sw+8, h+8, GameHud.hudColor);
	OutlinedRectangle(x+w/2-sw/2-4, y-h/2-4, sw+8, h+8, Colors.gray);
	System.textFont.drawText(x+w/2-sw/2, y-h/2, text);
}